#!/usr/bin/env python
# (coding: utf-8)
from distutils.core import setup
setup(name='script',
	version='1.4.1',
	author='Iain Lamb',
	author_email='x+python@lamb.cc',
	description='Concise shell scripting',
	url='http://lamb.cc/script',
	license='Copyright (c) 2009 by Iain Lamb. Licensed to PSF under a Contributor Agreement. See http://www.python.org/2.6/license for details.',
	py_modules=['script'],
	classifiers=['Development Status :: 5 - Production/Stable', 'Environment :: Console', 'Intended Audience :: Developers', 'Intended Audience :: System Administrators', 'License :: OSI Approved :: Python Software Foundation License', 'Natural Language :: English', 'Operating System :: OS Independent', 'Programming Language :: Python :: 3', 'Topic :: System :: Shells', 'Topic :: Terminals', 'Topic :: Utilities'],
	long_description="""Use with Python 3.


This module distills a collection of common shell script patterns into a few
terse definitions. Most of the objects and functions wrap lower-level calls to
modules in the standard Python library such as ``optparse``, ``os.path``, ``shutil``,
and ``subprocess``.

With just one ``import`` statement, you can provide your script with ready to go
command line parsing, convenient path operations, ala carte ``--help``
documentation, quick writes to ``stdout`` / ``stderr``, and easy invocation of shell
commands (including the ability to capture output).
""")
	